package org.msh.tb;

import org.jboss.seam.annotations.In;
import org.jboss.seam.annotations.Name;
import org.msh.tb.entities.UserMessage;
import org.msh.tb.login.UserSession;

import javax.persistence.EntityManager;
import java.util.ArrayList;
import java.util.List;

/**
 * Created by Mauricio on 24/07/2017.
 */
@Name("sessionMessagesHome")
public class SessionMessagesHome {

    @In
    EntityManager entityManager;

    @In(create=true)
    UserMessagesQuery userMessages;

    private Integer filterOption;

    /**
     * Stores he message result list
     */
    private List<UserMessage> userMessageResults;

    /**
     * Param used to store the message Id that is being read
     */
    private Integer messageId;

    /**
     * Loads all unread messages and set this list to userMessageResults
     */
    public void loadUnreadMessages() {
        userMessages.setFilterOption(userMessages.UNREAD_MESSAGES);

        // load unread messages
        userMessageResults = userMessages.getResultList();
    }


    /**
     * Register that a user has read (opened) a certain message. messageId
     * param is used to identify which message has been opened
     */
    public String userReadMessageWithRedirect() {

        userReadMessage();

        return filterOption == 1 ? "unread-msg" : "all-msg";
    }

    /**
     * Register that a user has read (opened) a certain message. messageId
     * param is used to identify which message has been opened
     */
    public void userReadMessage() {

        List<Object[]> result = entityManager.createNativeQuery("select * " +
                "from userreadmessage " +
                "where message_id = :mId and userworkspace_id = :uwId ")
                .setParameter("uwId", UserSession.getUserWorkspace().getId())
                .setParameter("mId", messageId)
                .getResultList();

        // avoid duplicated entries
        if (result == null || result.size() == 0) {
            entityManager.createNativeQuery("insert into userreadmessage values(:uwId,:mId)")
                    .setParameter("uwId", UserSession.getUserWorkspace().getId())
                    .setParameter("mId", messageId)
                    .executeUpdate();

            entityManager.createNativeQuery("update userworkspace set unreadMsgCounter = unreadMsgCounter-1 where id = :uwId")
                    .setParameter("uwId", UserSession.getUserWorkspace().getId())
                    .executeUpdate();

            // ajax loading is not updating user workspace in memory
            UserSession.getUserWorkspace().setUnreadMsgCounter(UserSession.getUserWorkspace().getUnreadMsgCounter() - 1);
        }

        loadUnreadMessages();
    }

    public List<UserMessage> getUserMessageResults() {
        return userMessageResults;
    }

    public void setUserMessageResults(List<UserMessage> userMessageResults) {
        this.userMessageResults = userMessageResults;
    }

    public Integer getMessageId() {
        return messageId;
    }

    public void setMessageId(Integer messageId) {
        this.messageId = messageId;
    }

    public Integer getFilterOption() {
        return filterOption;
    }

    public void setFilterOption(Integer filterOption) {
        this.filterOption = filterOption;
    }
}
